document.querySelectorAll('.liderazgo-card-vermas').forEach(btn => {
  btn.addEventListener('click', function (e) {
    e.preventDefault();

    // Obtener el texto del título de la card
    const card = this.closest('.liderazgo-card');
    const tituloCard = card.querySelector('h3')?.innerText.trim().toLowerCase();

    if (!tituloCard) return;

    // Buscar secciones con h1 que contengan parte del texto
    const secciones = document.querySelectorAll('.liderazgo-section h1');
    for (let h1 of secciones) {
      const textoH1 = h1.innerText.trim().toLowerCase();
      if (tituloCard.includes(textoH1) || textoH1.includes(tituloCard)) {
        h1.scrollIntoView({ behavior: 'smooth', block: 'center' });
        break;
      }
    }
  });
});